// SDR14xAppDlg.h : header file
//
//////////////////////////////////////////////////////////////////////
// Copyright 2003.    Moe Wheatley AE4JY  <http://www.moetronix.com>
//
//This program is free software; you can redistribute it and/or
//modify it how ever you wish.  Its primary goal is to provide an
// example for 3rd party software developers.  Support will be limited
// depending on my available time.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////
//{{AFX_INCLUDES()
#include "sdr14x.h"
//}}AFX_INCLUDES

#if !defined(AFX_SDR14APPDLG_H__35104349_40C2_4D70_B17E_14E47D1E5C1E__INCLUDED_)
#define AFX_SDR14APPDLG_H__35104349_40C2_4D70_B17E_14E47D1E5C1E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


/////////////////////////////////////////////////////////////////////////////
// CSDR14xAppDlg dialog

class CSDR14xAppDlg : public CDialog
{
// Construction
public:
	CSDR14xAppDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSDR14xAppDlg)
	enum { IDD = IDD_SDR14APP_DIALOG };
	CStatic	m_TestTextCtrl;
	CComboBox	m_HFGainComboCtrl;
	CComboBox	m_IFFilterComboCtrl;
	CComboBox	m_IfGainComboCtrl;
	CComboBox	m_InSrcComboCtrl;
	CStatic	m_StatusTxtCtrl;
	CSDR14X	m_CtrlSdr14X;
	CString	m_BootRevisionTxt;
	CString	m_DeviceNameTxt;
	CString	m_FirmwareRevisionTxt;
	CString	m_SerialNumberTxt;
	long	m_NCOfrequency;
	CString	m_SampFreqTxt;
	BYTE	m_Blocks;
	BOOL	m_DisplayFFT;
	int		m_SampleMode;
	CString	m_FFTsizeTxt;
	CString	m_SpanTxt;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSDR14xAppDlg)
	public:
	virtual BOOL DestroyWindow();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSDR14xAppDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnStatusChangeXsdr14ctrl(long Status);
	afx_msg void OnStopbutton();
	afx_msg void OnStartbutton();
	afx_msg void OnSelchangeInsrccombo();
	afx_msg void OnSelchangeHfgaincombo();
	afx_msg void OnSelchangeIffiltercombo();
	afx_msg void OnSelchangeIfgaincombo();
	afx_msg void OnDataRdyXsdr14ctrl(long BlocksAvailable);
	afx_msg void OnKillfocusNcoedit();
	afx_msg void OnAuxsend();
	afx_msg void OnUartDataRdyXsdr14ctrl();
	afx_msg void OnFftcheck();
	afx_msg void OnDeltaposSpanspin(NMHDR* pNMHDR, LRESULT* pResult);
	DECLARE_EVENTSINK_MAP()
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void SetupFFT(BOOL On);
	void DrawPlot();

	bool m_ComplexData;
	int m_DisplayBufSize;
	long m_LastStatus;
	int m_SpanFrequency;
	int m_FFTSize;
	CRect m_rPlot;		// client plot screen rectangle coordinates
	CRect m_rLastPlot;	// last Plot rectange used to see if size changed
	RECT m_rPlotsize;	// size of the plot screen bitmap
	CBitmap m_bmPlot;	// bitmap image of plot window
	CDC m_MemDC;
	CPen* m_pGPen;		// colored pens used for drawing plots
	CPen* m_pRPen;
	CPen* m_pBPen;
	long* m_pDispArray;	//xApps array for storing display data
	short m_pAuxTxMsg[24];
	short m_pAuxRxMsg[24];
	CString m_Str;

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SDR14APPDLG_H__35104349_40C2_4D70_B17E_14E47D1E5C1E__INCLUDED_)
