// SDR14xAppDlg.cpp : implementation file
//////////////////////////////////////////////////////////////////////
// Copyright 2003.    Moe Wheatley AE4JY  <http://www.moetronix.com>
//
//This program is free software; you can redistribute it and/or
//modify it how ever you wish.  Its primary goal is to provide an
// example for 3rd party software developers.  Support will be limited
// depending on my available time.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//
////////////////////////////////////////////////////////////////////////
//

#include "stdafx.h"
#include "SDR14xApp.h"
#include "SDR14xAppDlg.h"
#include "math.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define STATUS_NOTCONNECTED 0	//SDR-14,IQ status codes
#define STATUS_IDLECONNECTED 1
#define STATUS_RUNNING 2
#define STATUS_ERROR 3
#define STATUS_ADOVERLOAD 4

static BYTE g_test = 0;

//#define TEST_FILE 1

#ifdef TEST_FILE
FILE *strmout = NULL;
double Buf[32769];
int count = 0;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSDR14xAppDlg dialog

CSDR14xAppDlg::CSDR14xAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSDR14xAppDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSDR14xAppDlg)
	m_BootRevisionTxt = _T("");
	m_DeviceNameTxt = _T("");
	m_FirmwareRevisionTxt = _T("");
	m_SerialNumberTxt = _T("");
	m_NCOfrequency = 680000;
	m_SampFreqTxt = _T("");
	m_Blocks = 1;
	m_DisplayFFT = TRUE;
	m_SampleMode = 1;
	m_FFTsizeTxt = _T("");
	m_SpanTxt = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pRPen = NULL;
	m_pGPen = NULL;
	m_pBPen = NULL;
	m_SpanFrequency = 33333333;
}

void CSDR14xAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSDR14xAppDlg)
	DDX_Control(pDX, IDC_TESTTXT, m_TestTextCtrl);
	DDX_Control(pDX, IDC_HFGAINCOMBO, m_HFGainComboCtrl);
	DDX_Control(pDX, IDC_IFFILTERCOMBO, m_IFFilterComboCtrl);
	DDX_Control(pDX, IDC_IFGAINCOMBO, m_IfGainComboCtrl);
	DDX_Control(pDX, IDC_INSRCCOMBO, m_InSrcComboCtrl);
	DDX_Control(pDX, IDC_STATUSTXT, m_StatusTxtCtrl);
	DDX_Control(pDX, IDC_XSDR14CTRL, m_CtrlSdr14X);
	DDX_Text(pDX, IDC_BRTEXT, m_BootRevisionTxt);
	DDX_Text(pDX, IDC_DNTEXT, m_DeviceNameTxt);
	DDX_Text(pDX, IDC_FRTEXT, m_FirmwareRevisionTxt);
	DDX_Text(pDX, IDC_SNTEXT, m_SerialNumberTxt);
	DDX_Text(pDX, IDC_NCOEDIT, m_NCOfrequency);
	DDV_MinMaxLong(pDX, m_NCOfrequency, 1, 30000000);
	DDX_Text(pDX, IDC_SAMPFREQTEXT, m_SampFreqTxt);
	DDX_Text(pDX, IDC_BLOCKSEDIT, m_Blocks);
	DDV_MinMaxByte(pDX, m_Blocks, 1, 128);
	DDX_Check(pDX, IDC_FFTCHECK, m_DisplayFFT);
	DDX_Radio(pDX, IDC_MODE0, m_SampleMode);
	DDX_Text(pDX, IDC_FFTSIZETXT, m_FFTsizeTxt);
	DDX_Text(pDX, IDC_SPANTXT, m_SpanTxt);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSDR14xAppDlg, CDialog)
	//{{AFX_MSG_MAP(CSDR14xAppDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_STOPBUTTON, OnStopbutton)
	ON_BN_CLICKED(IDC_STARTBUTTON, OnStartbutton)
	ON_CBN_SELCHANGE(IDC_INSRCCOMBO, OnSelchangeInsrccombo)
	ON_CBN_SELCHANGE(IDC_HFGAINCOMBO, OnSelchangeHfgaincombo)
	ON_CBN_SELCHANGE(IDC_IFFILTERCOMBO, OnSelchangeIffiltercombo)
	ON_CBN_SELCHANGE(IDC_IFGAINCOMBO, OnSelchangeIfgaincombo)
	ON_EN_KILLFOCUS(IDC_NCOEDIT, OnKillfocusNcoedit)
	ON_BN_CLICKED(IDC_AUXSEND, OnAuxsend)
	ON_BN_CLICKED(IDC_FFTCHECK, OnFftcheck)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPANSPIN, OnDeltaposSpanspin)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSDR14xAppDlg message handlers

BOOL CSDR14xAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	if(m_pRPen==NULL)
	{
		m_pRPen = new CPen;
		m_pRPen->CreatePen( PS_SOLID,0, RGB(255,0,0) );
		m_pGPen = new CPen;
		m_pGPen->CreatePen( PS_SOLID,0, RGB(0,255,0) );
		m_pBPen = new CPen;
		m_pBPen->CreatePen( PS_SOLID,0, RGB(64,64,0) );
	}
	m_ComplexData = TRUE;
	m_SampFreqTxt = "";
	m_pDispArray = NULL;
	m_DisplayBufSize = 0;
	m_LastStatus = -1;
//Screen initial settings
	m_Blocks = 1;
	m_DisplayFFT = TRUE;
	m_SampleMode = 0;
	m_CtrlSdr14X.InitControl();
	m_InSrcComboCtrl.SetCurSel(3);	//HF AD6620 Complex mode
	m_CtrlSdr14X.SetInputSource(0x81);
	m_HFGainComboCtrl.SetCurSel(0);	//0dB HF atten
	m_CtrlSdr14X.SetHFgain(0);
	m_IFFilterComboCtrl.SetCurSel(5);	//150KHz filter
	m_CtrlSdr14X.SetIFfilter(5);
	m_IfGainComboCtrl.SetCurSel(3);		//+18dB IF gain
	m_CtrlSdr14X.SetIFgain(18);
	m_SpanFrequency = m_CtrlSdr14X.GetSampleRate()/2;
	m_SpanFrequency = (m_SpanFrequency/1000)*1000;
	m_SpanTxt.Format("+/- %d",m_SpanFrequency);
//	m_CtrlSdr14X.InitServerControl(0x7F000001, 1414);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//Called by system on close so can delete all the resources
BOOL CSDR14xAppDlg::DestroyWindow() 
{
	m_CtrlSdr14X.CloseUartPort();
	m_CtrlSdr14X.Stop();
	if(m_pRPen)
	{
		m_pRPen->DeleteObject();
		delete m_pRPen;
		m_pGPen->DeleteObject();
		delete m_pGPen;
		m_pBPen->DeleteObject();
		delete m_pBPen;
	}
	if(m_pDispArray)	//if display buffer exists then delete
	{
		delete m_pDispArray;
		m_pDispArray = NULL;
	}
	return CDialog::DestroyWindow();
}

void CSDR14xAppDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// Intercept keyboard messages to get around the stupid dialog ENTER key problem
BOOL CSDR14xAppDlg::PreTranslateMessage(MSG* pMsg) 
{
	if(pMsg->message==WM_KEYDOWN)	//map Enter key to Tab key so program
    {								//won't exit if you hit enter.
        if(pMsg->wParam==VK_RETURN)
            pMsg->wParam=VK_TAB;
    }	
	return CDialog::PreTranslateMessage(pMsg);
}

////////////////////////////////////////////////////////////////////////////
// Called by system to paint the dialog screen
////////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	if (IsIconic())
	{
		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else	//here if need to paint the screen
	{
		// Get pixel size of plot area bitmap
		CWnd* pWnd = GetDlgItem( IDC_PLOTFRAME );
		ASSERT_VALID( pWnd);
		pWnd->GetWindowRect( m_rPlot );
		ScreenToClient( &m_rPlot );	//convert to client coordinates
		m_rPlotsize.left = 0;		//keep copy of plot rectangle size
		m_rPlotsize.top = 0;
		m_rPlotsize.right = m_rPlot.Width();
		m_rPlotsize.bottom = m_rPlot.Height();
		if( m_rPlot!=m_rLastPlot )	//if size change then must redo the world
		{
			m_rLastPlot = m_rPlot;
			if( m_MemDC.m_hDC  != NULL )	// if MemDC exists then delete
			{	
				m_MemDC.Detach();
				m_MemDC.DeleteDC( );
			}
			m_MemDC.CreateCompatibleDC( &dc );	//create a new one
			if( m_bmPlot.m_hObject != NULL )	// delete old bitmap object
				m_bmPlot.DeleteObject();
			//create a new bitmap with current screen DC settings and plot area size
			m_bmPlot.CreateCompatibleBitmap( &dc, m_rPlotsize.right, m_rPlotsize.bottom );
			DrawPlot();	//go draw the data plot
		}
		CDialog::OnPaint();
	}
}

//////////////////////////////////////////////////////////////////////
//  Called to draw the specific plot surface when new data is available
//////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::DrawPlot()
{
CClientDC dc(this);
CBitmap* pbmOld;
CPen* pOldPen;
int x,y,k1;
	if(!m_pDispArray)	//if display buffer doesn't exist just return
		return;
	pbmOld = m_MemDC.SelectObject( &m_bmPlot );
	pOldPen = m_MemDC.SelectObject(m_pGPen);
	//clear display bitmap
	m_MemDC.SetBkColor( RGB(0,0,0) );
	m_MemDC.ExtTextOut( 0, 0,ETO_OPAQUE, &m_rPlotsize,NULL,0,NULL);
	if(m_DisplayFFT)	//Plot FFT Data
	{
		m_MemDC.SelectObject(m_pBPen);
		//draw y scale lines
		for( y=0; y<m_rPlotsize.bottom; y+=(m_rPlotsize.bottom/14) )
		{
			m_MemDC.MoveTo( 0, y);
			m_MemDC.LineTo( m_rPlotsize.right, y);
		}
		m_MemDC.SelectObject(m_pGPen);
		m_MemDC.MoveTo( 0, m_rPlotsize.bottom);
		m_CtrlSdr14X.GetFftScreendata(m_rPlotsize.bottom,
										m_rPlotsize.right,
										0,
										-140,
										-m_SpanFrequency,
										m_SpanFrequency,
										m_pDispArray);
		for( x=1; x<m_rPlotsize.right; x++)
		{
			y = m_pDispArray[x];
			m_MemDC.LineTo( x, y);
		}
	}
	else	//Plot Time Domain Data
	{
		m_MemDC.SelectObject(m_pBPen);
		k1 = m_rPlotsize.bottom/2;	//get plot y axis middle
		m_MemDC.MoveTo( 0, k1);		//draw horz center line
		m_MemDC.LineTo( m_rPlotsize.right, k1);
		int samples = m_CtrlSdr14X.GetLongData( m_pDispArray);
		int max = 0;
		int data;
		//scan all data for max so can scale to fit in screen
		for( x=1; x<m_rPlotsize.right; x++)	
		{
			data = abs( m_pDispArray[x] );
			if(data > max)		//find max data point
				max = data;
		}
		if(max==0)
			max = 1;
		max = max*2;	//scale so max is half of screen
		y = (m_pDispArray[0]*k1)/max + k1;	//scale to fit
		m_MemDC.SelectObject(m_pRPen);
		m_MemDC.MoveTo( 0, y);
		if(m_ComplexData)
		{	//complex data so plot I(odd) and Q(even) data separately
			for( x=1; x<m_rPlotsize.right; x++)
			{
				y = (m_pDispArray[x*2]*k1)/max + k1;
				m_MemDC.LineTo( x, y);
			}
			y = (m_pDispArray[1]*k1)/max + k1;
			m_MemDC.SelectObject(m_pGPen);
			m_MemDC.MoveTo( 0, y);
			for( x=1; x<m_rPlotsize.right; x++)
			{
				y = (m_pDispArray[x*2+1]*k1)/max + k1;
				m_MemDC.LineTo( x, y);
			}
		}
		else	//here to plot real so just plot all the points
		{
			m_MemDC.SelectObject(m_pGPen);
			for( x=1; x<m_rPlotsize.right; x++)
			{
				y = (m_pDispArray[x]*k1)/max + k1;
				m_MemDC.LineTo( x, y);
			}
		}
	}
	// Copy plot bitmap into screen device context for flicker free update
	dc.BitBlt( m_rPlot.left, m_rPlot.top,
					m_rPlotsize.right,
				m_rPlotsize.bottom, &m_MemDC,
					0,0,SRCCOPY);
	m_MemDC.SelectObject(pOldPen);	//deselect pens and bitmap
	m_MemDC.SelectObject( pbmOld );
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSDR14xAppDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BEGIN_EVENTSINK_MAP(CSDR14xAppDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CSDR14xAppDlg)
	ON_EVENT(CSDR14xAppDlg, IDC_XSDR14CTRL, 1 /* StatusChange */, OnStatusChangeXsdr14ctrl, VTS_I4)
	ON_EVENT(CSDR14xAppDlg, IDC_XSDR14CTRL, 2 /* DataRdy */, OnDataRdyXsdr14ctrl, VTS_I4)
	ON_EVENT(CSDR14xAppDlg, IDC_XSDR14CTRL, 3 /* UartDataRdy */, OnUartDataRdyXsdr14ctrl, VTS_NONE)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

//+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
//                 XSDR14 Control Event Handlers
//+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
//////////////////////////////////////////////////////////////////////
//	Called by ActiveX control system when SDR-14 USB changes
//////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnStatusChangeXsdr14ctrl(long Status) 
{
	switch(Status)
	{
		case STATUS_NOTCONNECTED:
			m_Str.Format("USB Not Connected", Status);
//			::Beep( 700,200);	//if you like noise
			break;
		case STATUS_IDLECONNECTED:
			m_Str.Format("USB Idle", Status);
			break;
		case STATUS_RUNNING:
			m_Str.Format("SDR-14 Running", Status);
			break;
		case STATUS_ERROR:
			m_Str.Format("Error", Status);
			break;
	}
	m_StatusTxtCtrl.SetWindowText( m_Str);
	if(Status != m_LastStatus)
	{
		m_LastStatus = Status;
		m_BootRevisionTxt.Format("Boot Ver. %g",(double)m_CtrlSdr14X.GetBootRevision()/100.0);
		m_DeviceNameTxt = m_CtrlSdr14X.GetDeviceName();
		m_FirmwareRevisionTxt.Format("Firm Ver. %g",(double)m_CtrlSdr14X.GetFirmwareRevision()/100.0);
		m_SerialNumberTxt = "SN = " + m_CtrlSdr14X.GetSerialNumber();
		UpdateData(FALSE);
	}
}

//////////////////////////////////////////////////////////////////////
//	Called by ActiveX control system when SDR-14 data is available
//////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnDataRdyXsdr14ctrl(long BlocksAvailable) 
{
#ifdef TEST_FILE
	if( (count < 110) && (count >= 100) )
	{
//		int samples;
//		samples = m_CtrlSdr14X.GetDoubleData(Buf);
//		int j=0;
//		for(int i=0; i<samples; i++)
//		{
//			fprintf(strmout,"%g, %g\n", Buf[j], Buf[j+1] );
//			j+=2;
//		}
		m_CtrlSdr14X.GetFftDoubleData(Buf);
		for(int i=0; i<m_FFTSize; i++)
		{
			fprintf(strmout,"%d, %g\n", i, Buf[i] );
		}
	}
	else
	{
		DrawPlot();	
	}
	count++;
#else
		DrawPlot();	
#endif
}

//////////////////////////////////////////////////////////////////////
//	Called by ActiveX control system when SDR-14 UART Rx data is available
//////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnUartDataRdyXsdr14ctrl() 
{
	//loopback test for UART data
	int len = m_CtrlSdr14X.GetUartData( m_pAuxRxMsg );
	for(int i=0; i<len; i++)
	{
		if(m_pAuxRxMsg[i] == g_test)
		{
			g_test++;
			m_pAuxTxMsg[i] = g_test;
		}
		else
			g_test = g_test;
	}
	m_Str.Format("%X",(BYTE)g_test);
	m_TestTextCtrl.SetWindowText(m_Str);
	m_CtrlSdr14X.SendUartData( m_pAuxTxMsg, len);
}


//+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-
//            Dialog and Control Notification Handlers
//+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-

/////////////////////////////////////////////////////////////////////////
// Called when FFTDisplay Check button is clicked
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnFftcheck()		
{
	UpdateData(TRUE);	
	SetupFFT(m_DisplayFFT);
}

/////////////////////////////////////////////////////////////////////////
// Called when Start button is clicked
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnStartbutton() 
{
int bufsize;
	if(m_LastStatus != STATUS_IDLECONNECTED)
		return;
	UpdateData(TRUE);			//make sure all setup data is current
	OnSelchangeInsrccombo();	//do first to determine real or complex data
	OnSelchangeHfgaincombo();
	OnSelchangeIffiltercombo();
	OnKillfocusNcoedit();
	//create display buffer whose size is dependent on the block size
	bufsize = m_Blocks*4096;
	if(m_pDispArray && m_DisplayBufSize!=bufsize)
	{
		delete m_pDispArray;	//delete previosu one if size changed
		m_pDispArray = NULL;
	}
	m_DisplayBufSize = bufsize;
	if(!m_pDispArray)
		m_pDispArray = new long[m_DisplayBufSize];
	SetupFFT(m_DisplayFFT);	//make sure fft is setup ok
	m_CtrlSdr14X.Start( m_Blocks ,m_SampleMode);
	//update sample rate text box
	m_SampFreqTxt.Format("%d Hz", m_CtrlSdr14X.GetSampleRate() );
	UpdateData(FALSE);

#ifdef TEST_FILE
strmout = fopen("c:\\Test.csv","w");
#endif
}

/////////////////////////////////////////////////////////////////////////
// Called when Stop button is clicked
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnStopbutton() 
{
	if(m_LastStatus != STATUS_RUNNING)
		return;
	UpdateData(TRUE);
	m_CtrlSdr14X.Stop();
#ifdef TEST_FILE
	if(strmout)
	{
	fclose(strmout);
	strmout = NULL;
}
#endif

}

/////////////////////////////////////////////////////////////////////////
// Called when Input source combo box is changed.
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnSelchangeInsrccombo() 
{
INT src;
	switch(m_InSrcComboCtrl.GetCurSel() )
	{	//convert group number to Input settings
		case 0:			//Direct Non-AD6620 Real mode
			src = 0x00;
			m_ComplexData = FALSE;
			break;
		case 1:			//Direct AD6620 Complex mode
			src = 0x80;
			m_ComplexData = TRUE;
			break;
		case 2:			//HF Non-AD6620 Real mode
			src = 0x01;
			m_ComplexData = FALSE;
			break;
		case 3:			//HF AD6620 Complex mode
			src = 0x81;
			m_ComplexData = TRUE;
			break;
	}
	m_CtrlSdr14X.SetInputSource(src);
	OnSelchangeIffiltercombo();		//update IF filter for display
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////
// Called when HF Gain combo box is changed.
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnSelchangeHfgaincombo() 
{
INT gn;
	switch(m_HFGainComboCtrl.GetCurSel() )
	{
		case 0:			//convert group number to dB settings
			gn = 0;
			break;
		case 1:
			gn = -10;
			break;
		case 2:
			gn = -20;
			break;
		case 3:
			gn = -30;
			break;
	}
	m_CtrlSdr14X.SetHFgain(gn);
}

/////////////////////////////////////////////////////////////////////////
// Called when IF Filter combo box is changed.
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnSelchangeIffiltercombo() 
{	//group number maps directly to filter numbers
	INT filternum = m_IFFilterComboCtrl.GetCurSel();
	m_CtrlSdr14X.SetIFfilter(filternum);
	m_SpanFrequency = m_CtrlSdr14X.GetSampleRate()/2;
	m_SpanFrequency = (m_SpanFrequency/1000)*1000;
	if(m_ComplexData)
	{
		m_SpanTxt.Format("+/- %d",m_SpanFrequency);
	}
	else
	{
		m_SpanTxt.Format(" %d",m_SpanFrequency);
	}
	UpdateData(FALSE);
}

/////////////////////////////////////////////////////////////////////////
// Called when IF Gain combo box is changed.
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnSelchangeIfgaincombo() 
{
INT gn;
	switch(m_IfGainComboCtrl.GetCurSel() )
	{	//convert group number to dB settings
		case 0:
			gn = 0;
			break;
		case 1:
			gn = 6;
			break;
		case 2:
			gn = 12;
			break;
		case 3:
			gn = 18;
			break;
		case 4:
			gn = 24;
			break;
	}
	m_CtrlSdr14X.SetIFgain( gn );
}

/////////////////////////////////////////////////////////////////////////
// Called when NCO frequency edit box is changed(loses focus)
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnKillfocusNcoedit() 
{
	UpdateData(TRUE);
	m_CtrlSdr14X.SetNCOfrequency(m_NCOfrequency);	
}

/////////////////////////////////////////////////////////////////////////
// Called when AUX Test button is clicked (disabled)
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::OnAuxsend() 
{
	m_pAuxTxMsg[0] = g_test;
	m_CtrlSdr14X.OpenUartPort( 9600,1,FALSE);
	m_CtrlSdr14X.SendUartData( m_pAuxTxMsg, 1);
	m_CtrlSdr14X.OpenSpiPort(0);
	m_CtrlSdr14X.SendSpiData( 0x55555555, 0xF00F0FF0, 10);
}

/////////////////////////////////////////////////////////////////////////
// Helper function to recalculate FFT parameters if something changes
// that may require a new setup
/////////////////////////////////////////////////////////////////////////
void CSDR14xAppDlg::SetupFFT(BOOL On)
{
int fftsize = 18;	//2^18 = 262144 = max fft size
int samples = m_DisplayBufSize;
int points;
	if(m_ComplexData)	//if complex then are half as many I/Q samples
		samples /= 2;
	do
	{	//figure out maximum FFT that can be done on buffer.
		points = (int)pow(2.0,(double)fftsize);	//has to be power of 2
		if(samples >= points)
			break;
		fftsize--;
	}while(points>2048);	//min FFT is 2048
	if(On)
		m_CtrlSdr14X.SetupFFT( points,1,FALSE);	//fixed average=1 and no inversion
	else
		m_CtrlSdr14X.SetupFFT( 0, 0, 0);	//disable FFT system
	m_FFTSize = points;
	m_FFTsizeTxt.Format("FFT Size = %d",points);
}

void CSDR14xAppDlg::OnDeltaposSpanspin(NMHDR* pNMHDR, LRESULT* pResult) 
{
int limit = m_CtrlSdr14X.GetSampleRate()/2;
	limit = (limit/1000)*1000;
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	m_SpanFrequency = m_SpanFrequency - 1000*(pNMUpDown->iDelta);
	if(m_SpanFrequency < 1000 )
		m_SpanFrequency = 1000;
	if(m_SpanFrequency > limit )
		m_SpanFrequency = limit;
	m_SpanFrequency = (m_SpanFrequency/1000)*1000;
	if(m_ComplexData)
	{
		m_SpanTxt.Format("+/- %d",m_SpanFrequency);
	}
	else
	{
		m_SpanTxt.Format(" %d",m_SpanFrequency);
	}
	UpdateData(FALSE);
	
	*pResult = 0;
}
