set_property IOSTANDARD LVCMOS33 [get_ports ADC_CLKIN]
set_property IOSTANDARD LVCMOS33 [get_ports ADC_CLKEN]
set_property IOSTANDARD LVCMOS33 [get_ports BBB_SCLK]
set_property IOSTANDARD LVCMOS33 [get_ports GPS_TCXO]
set_property IOSTANDARD LVCMOS33 [get_ports IF_SGN]
set_property IOSTANDARD LVCMOS33 [get_ports IF_MAG]
set_property IOSTANDARD LVCMOS33 [get_ports {BBB_CS_N[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {BBB_CS_N[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports BBB_MISO]
set_property IOSTANDARD LVCMOS33 [get_ports BBB_MOSI]
set_property IOSTANDARD LVCMOS33 [get_ports ADC_OVFL]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[13]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[12]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[11]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[10]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[9]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[8]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[7]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[6]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[5]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[4]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[3]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[2]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[1]}]
set_property IOSTANDARD LVCMOS33 [get_ports {ADC_DATA[0]}]
set_property IOSTANDARD LVCMOS33 [get_ports G014]
set_property IOSTANDARD LVCMOS33 [get_ports G015]
set_property IOSTANDARD LVCMOS33 [get_ports G117]
set_property IOSTANDARD LVCMOS33 [get_ports G116]
set_property IOSTANDARD LVCMOS33 [get_ports G031]
set_property IOSTANDARD LVCMOS33 [get_ports G030]
set_property IOSTANDARD LVCMOS33 [get_ports P826]
set_property IOSTANDARD LVCMOS33 [get_ports P819]
set_property IOSTANDARD LVCMOS33 [get_ports P817]
set_property IOSTANDARD LVCMOS33 [get_ports P818]
set_property IOSTANDARD LVCMOS33 [get_ports P815]
set_property IOSTANDARD LVCMOS33 [get_ports P816]
set_property IOSTANDARD LVCMOS33 [get_ports P813]
set_property IOSTANDARD LVCMOS33 [get_ports P814]
set_property IOSTANDARD LVCMOS33 [get_ports P811]
set_property IOSTANDARD LVCMOS33 [get_ports P812]
set_property IOSTANDARD LVCMOS33 [get_ports EWP]

set_property PACKAGE_PIN E12 [get_ports ADC_CLKIN]
set_property PACKAGE_PIN A8 [get_ports ADC_CLKEN]
set_property PACKAGE_PIN D13 [get_ports BBB_SCLK]
set_property PACKAGE_PIN D4 [get_ports GPS_TCXO]
set_property PACKAGE_PIN B1 [get_ports IF_SGN]
set_property PACKAGE_PIN B2 [get_ports IF_MAG]
set_property PACKAGE_PIN P16 [get_ports {BBB_CS_N[1]}]
set_property PACKAGE_PIN N16 [get_ports {BBB_CS_N[0]}]
set_property PACKAGE_PIN M15 [get_ports BBB_MISO]
set_property PACKAGE_PIN J14 [get_ports BBB_MOSI]
set_property PACKAGE_PIN F15 [get_ports ADC_OVFL]
set_property PACKAGE_PIN E16 [get_ports {ADC_DATA[13]}]
set_property PACKAGE_PIN E15 [get_ports {ADC_DATA[12]}]
set_property PACKAGE_PIN D16 [get_ports {ADC_DATA[11]}]
set_property PACKAGE_PIN D15 [get_ports {ADC_DATA[10]}]
set_property PACKAGE_PIN C16 [get_ports {ADC_DATA[9]}]
set_property PACKAGE_PIN B16 [get_ports {ADC_DATA[8]}]
set_property PACKAGE_PIN B15 [get_ports {ADC_DATA[7]}]
set_property PACKAGE_PIN A15 [get_ports {ADC_DATA[6]}]
set_property PACKAGE_PIN B14 [get_ports {ADC_DATA[5]}]
set_property PACKAGE_PIN A14 [get_ports {ADC_DATA[4]}]
set_property PACKAGE_PIN C13 [get_ports {ADC_DATA[3]}]
set_property PACKAGE_PIN A13 [get_ports {ADC_DATA[2]}]
set_property PACKAGE_PIN B12 [get_ports {ADC_DATA[1]}]
set_property PACKAGE_PIN A12 [get_ports {ADC_DATA[0]}]
set_property PACKAGE_PIN K16 [get_ports G014]
set_property PACKAGE_PIN K15 [get_ports G015]
set_property PACKAGE_PIN M16 [get_ports G117]
set_property PACKAGE_PIN P15 [get_ports G116]
set_property PACKAGE_PIN R16 [get_ports G031]
set_property PACKAGE_PIN R15 [get_ports G030]
set_property PACKAGE_PIN L5 [get_ports P826]	; # G129
set_property PACKAGE_PIN L4 [get_ports P819]	; # G022
set_property PACKAGE_PIN M2 [get_ports P817]	; # G027
set_property PACKAGE_PIN M1 [get_ports P818]	; # G201
set_property PACKAGE_PIN N2 [get_ports P815]	; # G115
set_property PACKAGE_PIN N1 [get_ports P816]	; # G114
set_property PACKAGE_PIN N3 [get_ports P813]	; # G023
set_property PACKAGE_PIN P1 [get_ports P814]	; # G026
set_property PACKAGE_PIN R1 [get_ports P811]	; # G113
set_property PACKAGE_PIN R2 [get_ports P812]	; # G112
set_property PACKAGE_PIN H1 [get_ports EWP]

# outputs
set_property DRIVE 4 [all_outputs]
set_property OFFCHIP_TERM NONE [all_outputs]
#set_property SLEW FAST [get_ports BBB_MISO]

# in Vivado for power analysis only
set_load 6.000 [all_outputs]

# 48 MHz
create_clock -period 20.833 -name BBB_SCLK -waveform {0.000 10.416} [get_ports BBB_SCLK]

# 16.368 MHz
create_clock -period 61.095 -name GPS_TCXO -waveform {0.000 30.548} [get_ports GPS_TCXO]

# 66.666666 & 66.666600 MHz
create_clock -period 15.000 -name ADC_CLKIN -waveform {0.000 7.500} [get_ports ADC_CLKIN]

set_input_delay -clock [get_clocks ADC_CLKIN] -min -add_delay 1.400 [get_ports {ADC_DATA[*]}]
set_input_delay -clock [get_clocks ADC_CLKIN] -max -add_delay 5.400 [get_ports {ADC_DATA[*]}]
set_input_delay -clock [get_clocks ADC_CLKIN] -min -add_delay 1.400 [get_ports ADC_OVFL]
set_input_delay -clock [get_clocks ADC_CLKIN] -max -add_delay 5.400 [get_ports ADC_OVFL]
set_input_delay -clock [get_clocks BBB_SCLK] -min -add_delay 6.846 [get_ports BBB_MOSI]
set_input_delay -clock [get_clocks BBB_SCLK] -max -add_delay 17.263 [get_ports BBB_MOSI]
set_input_delay -clock [get_clocks GPS_TCXO] -min -add_delay 10.000 [get_ports IF_SGN]
set_input_delay -clock [get_clocks GPS_TCXO] -max -add_delay 54.095 [get_ports IF_SGN]	; # gives Tsetup=7ns
set_input_delay -clock [get_clocks GPS_TCXO] -min -add_delay 10.000 [get_ports IF_MAG]
set_input_delay -clock [get_clocks GPS_TCXO] -max -add_delay 54.095 [get_ports IF_MAG]

# FIXME: is MISO timing marginal?
set_output_delay -clock [get_clocks BBB_SCLK] -max -add_delay 2.290 [get_ports BBB_MISO]
set_output_delay -clock [get_clocks BBB_SCLK] -min -add_delay -4.700 [get_ports BBB_MISO]

# arbitrary amount to keep timing report from complaining
set_output_delay -clock [get_clocks GPS_TCXO] -max -add_delay 1.000 [get_ports ADC_CLKEN]
set_output_delay -clock [get_clocks GPS_TCXO] -min -add_delay -1.000 [get_ports ADC_CLKEN]
set_output_delay -clock [get_clocks GPS_TCXO] -max -add_delay 1.000 [get_ports G015]	; # CTRL_INTERRUPT
set_output_delay -clock [get_clocks GPS_TCXO] -min -add_delay -1.000 [get_ports G015]
set_output_delay -clock [get_clocks GPS_TCXO] -max -add_delay 1.000 [get_ports EWP]
set_output_delay -clock [get_clocks GPS_TCXO] -min -add_delay -1.000 [get_ports EWP]

# SPI CS needs to have no setup/hold effect during SCLK
set_false_path -from [get_ports {BBB_CS_N[0] BBB_CS_N[1]}] -to [get_clocks BBB_SCLK]

# ignore ha_out3/d1 hold violations (on posedge of ha_clk) since d1 is always unchanged
set_false_path -rise_from [get_clocks BBB_SCLK] -to [get_ports BBB_MISO]

set_clock_groups -asynchronous -group [get_clocks GPS_TCXO] -group [get_clocks ADC_CLKIN]
set_clock_groups -asynchronous -group [get_clocks ADC_CLKIN] -group [get_clocks GPS_TCXO]
set_clock_groups -asynchronous -group [get_clocks GPS_TCXO] -group [get_clocks BBB_SCLK]
set_clock_groups -asynchronous -group [get_clocks BBB_SCLK] -group [get_clocks GPS_TCXO]

# config
set_property CONFIG_VOLTAGE 3.3 [current_design]
set_property CFGBVS VCCO [current_design]
set_property CONFIG_MODE S_SERIAL [current_design]
set_property BITSTREAM.CONFIG.USR_ACCESS 0x12345678 [current_design]

# power analyzer
set_operating_conditions -airflow 0
set_operating_conditions -board_layers 4to7
set_operating_conditions -board small
set_operating_conditions -heatsink none
set_switching_activity -default_toggle_rate 100.000
set_switching_activity -toggle_rate 100.000 -static_probability 0.500 [get_ports BBB_MISO]
