
// XtrFun.h  Header for common custom cpp routines.

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
double __stdcall xtf_Add42( double * X ) ;

#define VERSION_SUFFIX "20010130" // "981028" doesn't work for some reason

#pragma message( "Did you change \"VERSION_SUFFIX\" in XtrFun.h?" )

#define FALSE 0
#define TRUE 1
#define USE_PARABOLIC_INTERPOLATION 0
#define USE_CUBIC_SPLINE_INTERPOLATION 1
#define USE_LINEAR_INTERPOLATION 2
#define DEFAULT_INTERPOLATION_METHOD USE_PARABOLIC_INTERPOLATION
#define MAX_NGROUPS 256
#define SOLVE_FOR_PEAK 'P'
#define SOLVE_FOR_VALLEY 'V'
#define SOLVE_FOR_Y 'Y'
#define GUESSX_WAS_SPECIFIED_MASK 0x8080
#define DEFAULT_SOLVE_FOR_TYPE SOLVE_FOR_PEAK
#define DEFAULT_POWER 1
#define DEFAULT_ORDER_TO_SAVE_ROOM_FOR 16
#define DEFAULT_GUESSX 1
#define DEFAULT_ACCURACY 1e-10
#define DEFAULT_DELTA_X .01		// In XatY, change X by this amount times the span X
#define DEFAULT_MAX_ITERATIONS 100
#define DEFAULT_h .0001
#define DEFAULT_Y_TO_SEEK 1
#define USE_DEFAULT 2
#define NEAR_ZERO 1.0E-20

#define PI 3.141592653589793238
#define USE_VH_FORMULAS_FOR_CONSTANTS 0

// this was the largest VBA would accept for a double number
// for MSVC, DBL_MAX = 1.7976931348623158e+308
#define vbMAX_DOUBLE     1.797693e+308

// Possible function return values
#define NORMAL_RETURN 0
#define ERROR_RETURN 1
#define EXTRAPOLATION_WAS_REQUIRED 43

/* Possible function return values defined by Excel
Used for val.err field of XLOPER structure when constructing error XLOPERs

#define xlerrNull    0
#define xlerrDiv0    7
#define xlerrValue   15
#define xlerrRef     23
#define xlerrName    29
#define xlerrNum     36
#define xlerrNA      42
*/

#define Arg1IsBetweenArg2AndArg3( Arg1 , Arg2 , Arg3 ) \
		( ( ( ( Arg1 ) >= ( Arg2 ) ) && ( ( Arg1 ) <= ( Arg3 ) ) ) || \
		( ( ( Arg1 ) <= ( Arg2 ) ) && ( ( Arg1 ) >= ( Arg3 ) ) ) )

#define Arg1IsBetweenArg2AndArg3WithinFloatAccuracy( Arg1 , Arg2 , Arg3 ) \
		( ( ( ( (float)Arg1 ) >= ( (float)Arg2 ) ) && ( ( (float)Arg1 ) <= ( (float)Arg3 ) ) ) || \
		( ( ( (float)Arg1 ) <= ( (float)Arg2 ) ) && ( ( (float)Arg1 ) >= ( (float)Arg3 ) ) ) )



#define PROCESS_STD_RETURN_VALUES	switch ( error ) \
									{ \
										case NORMAL_RETURN : \
											break ; \
										case EXTRAPOLATION_WAS_REQUIRED : \
											ReturnValue = EXTRAPOLATION_WAS_REQUIRED ; \
											break ; \
										default : \
											return error ; \
											break ; \
									}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
//	Low Level I/O routines
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// xtf_lInputByte and xtf_lOutputByte functions mimic the BASIC and C functions
//
// Note that you really want signed char for the return value of xtf_lInputByte
//    and ByteToWrite of xtf_lOutputByte, and signed short for everything
//    else.  However, Excel supports neither signed char nor
//    signed short, so for simplicity's sake, long was used
//    for all of the variables.
//
// xtf_lOutputByte returns the tick count (milliseconds Windows has been running).
// This is to enable the calling program to most accurately determine the time
//    the output data was latched (using the system timer).
// Tick count changes every 55 milliseconds (f = 18.1818... Hz).
// Options = 0 => The I/O is performed and the tick count is returned, period.
// Options = 1 => If the tick count taken before outputing the data to the port
//    is different from the tick count taken after outputting data to the port,
//    the function returns 0.  It is up to the calling program to resend the
//    data to the port if such a return time is unacceptable.
// Options = 2 => The routine waits until just after a tick count change and
//    then immediately performs the I/O.  This is probably the most accurate
//    way of getting the system time.  The Options = 1 check is also made in
//    case a long interrupt had taken over.   0 is returned for the same
//    reason as Options = 1.
// Recommend Options = 2 if you want accurate timing, or 0 if you don't care.
//----------------------------------------------------------------------------
long __stdcall xtf_lInputByte(
		long IOAddress ) ;

long __stdcall xtf_lOutputByte(
		long IOAddress ,
		long ByteToWrite ,
		long Options ) ;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
//	Formatting routines
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//
//	LPSTR __stdcall xtf_NumberToString( const long ulNumber , const LPSTR FormatString ,
//			LPSTR ReturnString ) ;
//
//	Fills ReturnString with a string representation of ulNumber in the format #,##0.
//	FormatString oresently means nothing, but will be meaningful in the future, so enter
//	with FormatString = "#,##0".
//	ReturnString must be long enough to contain the character array plus a terminating \0.
//	Returns pointer to ReturnString.
//
//----------------------------------------------------------------------------
LPSTR __stdcall xtf_NumberToString(
		const long ulNumber ,
		const LPSTR FormatString ,
		LPSTR ReturnString ) ;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
//	1D numerical routines
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//
//	long xtf_IndexOfMaxDouble( double * DoubleArray , long npts )
//
//	returns n such that DoubleArray[n] >= all other DoubleArray elements
//	The index of the first element of the array = 0
//
//----------------------------------------------------------------------------
long __stdcall xtf_IndexOfMaxDouble(
		double * DoubleArray ,
		long npts ) ;

//----------------------------------------------------------------------------
//
//	long xtf_IndexOfMinDouble( double * DoubleArray , long npts )
//
//	returns n such that DoubleArray[n] <= all other DoubleArray elements
//	The index of the first element of the array = 0
//
//----------------------------------------------------------------------------
long __stdcall xtf_IndexOfMinDouble(
		double * DoubleArray ,
		long npts ) ;

//----------------------------------------------------------------------------
//
//	double xtf_ArrayMinimumD( double * l_pldArray , long l_lNumberOfElements )
//	long double xtf_ArrayMinimumLD( long double * l_pldArray , long l_lNumberOfElements )
//
//	double __stdcall xtf_ArrayMaximumD( double * l_pdArray , long l_lNumberOfElements ) ;
//	long double __stdcall xtf_ArrayMaximumLD( long double * l_pldArray , long l_lNumberOfElements ) ;
//
//	Returns the minimum (or maximum) value in the array
//
//----------------------------------------------------------------------------
double __stdcall xtf_ArrayMinimumD(
		double * l_pdArray ,
		long l_lNumberOfElements ) ;

long double __stdcall xtf_ArrayMinimumLD(
		long double * l_pldArray ,
		long l_lNumberOfElements ) ;

double __stdcall xtf_ArrayMaximumD(
		double * l_pdArray ,
		long l_lNumberOfElements ) ;

long double __stdcall xtf_ArrayMaximumLD(
		long double * l_pldArray ,
		long l_lNumberOfElements ) ;

//----------------------------------------------------------------------------
//
//	long xtf_IndexOfClosestValue( double * DoubleArray , long npts ,
//			double Value )
//
//	Returns n such that there is no other DoubleArray element closer to Value than DoubleArray[n]
//	The index of the first element of the array = 0
//
//----------------------------------------------------------------------------
long __stdcall xtf_IndexOfClosestValue(
		double * DoubleArray ,
		long npts ,
		double Value ) ;

//----------------------------------------------------------------------------
//
//	double xtf_LookupClosestValue( double * DoubleArray , long npts ,
//			double Value )
//
//	Like IndexOfClosestValue, except it returns the actual value which
//	is closest instead of the index.
//
//----------------------------------------------------------------------------
double __stdcall xtf_LookupClosestValue(
		double * DoubleArray ,
		long npts ,
		double Value ) ;

//----------------------------------------------------------------------------
//
//	BOOL xtf_ArrayIsConstantlyIncreasingOrDecreasing( double * DoubleArray ,
//			long npts )
//
//	Returns TRUE if and only if DoubleArray is either constantly increasing
//	or constantly decreasing
//
//----------------------------------------------------------------------------
BOOL __stdcall xtf_ArrayIsConstantlyIncreasingOrDecreasing(
		double * DoubleArray ,
		long npts ) ;

//----------------------------------------------------------------------------
//
//	void xtf_Swap( SomeNumberType * a , SomeNumberType * b )
//
//	SomeNumberType can be any numerical type
//
//	Sets a = b and b = original a
//
//----------------------------------------------------------------------------
void __stdcall xtf_Swap( char * a , char * b ) ;
void __stdcall xtf_Swap( unsigned char * a , unsigned char * b ) ;
void __stdcall xtf_Swap( short * a , short * b ) ;
void __stdcall xtf_Swap( unsigned short * a , unsigned short * b ) ;
void __stdcall xtf_Swap( long * a , long * b ) ;
void __stdcall xtf_Swap( unsigned long * a , unsigned long * b ) ;
void __stdcall xtf_Swap( float * a , float * b ) ;
void __stdcall xtf_Swap( double * a , double * b ) ;
void __stdcall xtf_Swap( long double * a , long double * b ) ;

//----------------------------------------------------------------------------
//
//	double xtf_Average( SomeNumberOrCharType * array , long npts )
//
//	array can be any type capable of being summed and averaged
//
//----------------------------------------------------------------------------
double __stdcall xtf_AverageD( double * pArray , unsigned long npts ) ;
double __stdcall xtf_AverageLD( long double * pArray , unsigned long npts ) ;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
//	2D numerical routines
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//
//	double __stdcall xtf_LookupClosestValue2D( double * XYArray ,
//		double * ArrayOfXKeys , double * ArrayOfYKeys ,
//		long nXs , long nYs ,
//		double XValue , double YValue ) ;
//
//	Returns value similar to LookupClosestValue except in two dimensions.
//
//----------------------------------------------------------------------------
double __stdcall xtf_LookupClosestValue2D(
		double * XYArray ,
		double * ArrayOfXKeys ,
		double * ArrayOfYKeys ,
		long nXs ,
		long nYs ,
		double XValue ,
		double YValue ) ;

//----------------------------------------------------------------------------
//
// long xtf_Spline( double * Xs , double * Ys , long npts , double X ,
//		double * Y , BOOL ExtrapolationIsAllowed ) ;
//
// Given an array of constantly increasing or decreasing X's with corresponding Y's,
//    and a given X, xtf_Spline returns the Y which lies on the spline curve at
//    the given X.
// The spline used is f(x) such that the first and second derivatives are equal
//    at all the given points and the second derivative is 0 at the ends.
//
// Returns:
//		xlerrNum	if number of points > MAX_SPLINE_POINTS
//					or number of points < 2
//					or Xs are neither constantly increasing nor constantly decreasing
//					extrapolation was required and ExtrapolationIsAllowed = FALSE
//
//----------------------------------------------------------------------------
long __stdcall xtf_Spline(
		double * Xs ,
		double * Ys ,
		long npts ,
		double X ,
		double * Y ) ;

//----------------------------------------------------------------------------
//
//	long xtf_Interpolate( double * Xs , double * Ys , long npts , double X ,
//		double * Y , BOOL ExtrapolationIsAllowed , BOOL Parabolic ,
//		BOOL Averaging , double Power ) ;
//
// Given an array of constantly increasing or decreasing X's with corresponding Y's,
//    and a given X, xtf_Interpolate returns the Y which lies on an interpolated curve at
//    the given X.
// Input:
//    An array of known X's and Y's.
//    A given X.
//    ExtrapolationIsAllowed, y/n.  If 0 or FALSE, no extrapolation is allowed, and an error results if the
//        given X is outside the bounds of the known X's.
//    Parabolic interpolation, y/n.  If 0 or FALSE, linear interpolation is used.  If 1 or TRUE,
//        parabolic interpolation is used.  Parabolic interpolation calculates the
//        Y which would lie on the parabola defined by the three known points surrounding
//        the given X.  If Averaging 0 or FALSE, the known point before the given X and
//        the two known points after the given X are used to define the parabola.  If only
//        two known points are supplied, parabolic interpolation is impossible, and linear
//        interpolation is used regardless of this setting.
//        Recommend parabolic interpolation, 1.
//    Averaging, y/n.  If 0 or FALSE, no averaging to smooth nodes is used.  If 1 or TRUE, and if
//        parabolic interpolation is enabled, and and if the given X is between the
//        second and the penultimate known X's, the parabolic interpolated Y is
//        calculated from both directions.  That is, first it calculates the Y on the
//        parabola defined by the known point to the left of the given X and the two
//        known points to the right of the given X.  Then it calculates the Y on the
//        parabola defined by the two known points to the left of the given X and the
//        known point to the right of the given X.  The two calculated Y's are weighted
//        according to how close the given X is to the left or right hand point.
//        Weight = ( Given_X - X_of_Point_on_Left ) /
//                 ( X_of_Point_on_Right - X_of_Point_on_Left )
//        Returned Y = Y_on_Parabola_Coming_from_the_Right * Weight +
//                     Y_on_Parabola_Coming_from_the_Left * ( 1 - Weight )
//        The result is a curve that very closly resembles a natural spline curve, but
//        which tends to be slightly flatter and able to draw a straight line.
//        Averaging only applies to parabolic interpolation.
//        Recommend enable averaging, 1.
//    Power, real number.  Averaging Weight is raised to Power and
//			if ( Weight <= .5 )
//				Weight = .5 * pow ( 2 * Weight , Power ) ;
//			else
//				Weight = 1 - .5 * pow ( 2 * ( 1 - Weight ) , Power ) ;
//        The effect of powers > 1 is to more closely follow the curve from the nearest
//        given point for a longer time.  If there is an inflection, it will be more
//        abrupt.  Given only the peaks and valleys of the Sine curve for the given Xs
//        and Ys, an almost perfect fit is obtained using 1.156 for the power.
//        Recommend power = 1.
//----------------------------------------------------------------------------
long __stdcall xtf_Interpolate(
		double * Xs ,
		double * Ys ,
		long npts ,
		double X ,
		double * Y ,
		signed short Parabolic ,
		signed short Averaging ,
		double Power ) ;

long __stdcall xtf_Interp(
		double * Xs ,
		double * Ys ,
		long npts ,
		double X ,
		double * Y ) ;

long __stdcall xtf_Intersect(
		double * X1s ,
		double * Y1s ,
		long npts1 ,
		double * X2s ,
		double * Y2s ,
		long npts2 ,
		double * GuessX ,
		signed short InterpolateSpline1 ,
		signed short InterpolateSpline2 ,
		double Accuracy ,
		long MaxIterations ,
		double h ) ;

long __stdcall xtf_XatY(
		double * Xs ,
		double * Ys ,
		long npts ,
		signed char SolveForType ,
		double GuessX ,
		double YtoSeek ,
		double * l_dReturnedXWithoutExtrapolation ,
		double * l_dReturnedXAllowingExtrapolation ,
		double * l_dReturnedYWithoutExtrapolation ,
		double * l_dReturnedYAllowingExtrapolation ) ;

long __stdcall xtf_dydx(
		double * Xs ,
		double * Ys ,
		long npts ,
		double X ,
		double * YPrime ) ;

long __stdcall xtf_ddydx(
		double * Xs ,
		double * Ys ,
		long npts ,
		double X ,
		double * YPrimePrime ) ;

long __stdcall xtf_PFit(
		double *	pdArrayOfIndependentVariables ,
		double *	pdArrayOfObservedYs ,
		long		lNumberOfObservations ,
		double		dGivenX ,
		long		lOrder ,
		double *	pdPolynomialFitY ) ;

long __stdcall xtf_PFitData(
		double *	pdArrayOfIndependentVariables ,
		double *	pdArrayOfObservedYs ,
		long		lNumberOfPoints ,
		long		lOrder ,
		double *	pdResultArray ) ;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
//	3D numerical routines
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

long __stdcall xtf_Interp3D(
		double * Xs ,
		double * Ys ,
		double * Zs ,
		long npts ,
		double X ,
		double Y ,
		double * Z ,
		BOOL ExtrapolationIsAllowed ,
		signed short ConstantXInterpolationMethod ,
		signed short ConstantYInterpolationMethod );

long __stdcall xtf_InterpMatrix(
		double * Matrix ,
		double X ,
		double Y ,
		double * Z ,
		signed short Parabolic ) ;

long __stdcall xtf_InterpLinMatrix(
		double * l_dMatrix ,
		double l_dX ,
		double l_dY ,
		double * l_dReturnedZ ) ;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
// Functions of limited general use, but exported anyway
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
long __stdcall xtf_GetStartingPointAndPointAfterKnowingX(
		double * Xs ,
		long npts , double X ,
		signed short Parabolic ,
		long * StartingPoint ,
		long * PointAfter ) ;

double __stdcall xtf_CalculateParabolicY(
		double * Xs ,
		double * Ys ,
		double X ,
		long StartingPoint ) ;
		// Function used by xtf_Interpolate()

void __stdcall xtf_CalculateParabolaCoefficients(
		double * Xs ,
		double * Ys ,
		long StartingPoint ,
		double * a ,
		double * b ,
		double * c ) ;
		// Calculates coefficients a, b, and c for y = ax^2 + bx + c

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//
// End of functions of limited general use, but exported anyway
//
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

void __stdcall xtf_CalculateConstants(
	// Metric Input Data
		double *	dSiteElevation ,
		double *	dSiteLatitude ,
		double *	dWaterTemperature ,
		long	wVHorASMEgFormula , // USE_VH_FORMULAS_FOR_CONSTANTS => ... else ASME
	// Metric Output
		double *	dLocalG ,
		double *	dRho ,
		double *	dRhoG ,
		double *	dHVapor ,
		double *	dHBar ,
		double *	dNu ) ;

void __stdcall xtf_PolynomialCurveFit(
		double * pdArrayOfIndependentVariables ,
		double * pdArrayOfObservedYs ,
		long lNumberOfObservations ,
		long lOrder ,
		long double * pdRegressionCoefficients ,
		long double * pdArrayOfEstimatedYs ,
		long double * pdArrayResiduals ,
		long double * pdStandardErrorOfEstimate ,
		long double * l_pdArrayOfStandardErrorOfEstimatesOfCoefficients ,
		long double * pdRSquaredCoefficientOfDetermination ,
		long double * pdRCorrelationCoefficient ,
		long double * l_pldRegressionMatrix ,
		char *   pc0IfNoError ) ;

void __stdcall xtf_CalculateMultipleRegessionCoefficients(
		long double * pdArrayOfIndependentVariables ,
		long double * pdArrayOfObservedYs ,
		long          nNumberOfIndependentVariables ,
		long          nNumberOfObservations ,
		long double * pdRegressionCoefficients ,
		long double * pdArrayOfEstimatedYs ,
		long double * pdArrayResiduals ,
		long double * pdStandardErrorOfEstimate ,
		long double * l_pdArrayOfStandardErrorOfEstimatesOfCoefficients ,
		long double * pdRSquaredCoefficientOfDetermination ,
		long double * pdRCorrelationCoefficient ,
		long double * l_pldRegressionMatrix ,
		char *   pc0IfNoError ) ;

void __stdcall xtf_GaussJordan(
		long double * pdSquareMatrixOfXVariableCoefficients ,
		long double * pdArrayOfYValues ,
		long         nNumberOfEquations ,
		long double * pdArrayOfSolutions ,
		long double * pdInverseOfSquareMatrixOfXVariableCoefficients ,
		long double * pdDeterminantOfMatrixOfXVariableCoefficients ) ;

long double xtf_CalculateYFromPolynomialCoefficients(
		long double l_ldXIn ,
		long double * l_pldArrayOfPolynomialCoefficients ,
		long l_lOrder ) ;

void MatTxTiX( long double * aryin , long  numrow , long  numcol , long double * aryout ) ;

void MatYTiX( long double * aryy , long double * aryx , long  numrow ,
		long  numcol , long double * aryout ) ;

void ResidualsAnalysis(
		long double *	regmat ,
		long double *	ymat ,
		long double *	pdRegressionCoefficients ,
		long double *	aryinv ,
		long				numrow ,
		long				numcol ,
		long double *	pdArrayOfEstimatedYs ,
		long double *	pdArrayResiduals ,
		long double *	pdStandardErrorOfEstimate ,
		long double *	l_pdArrayOfStandardErrorOfEstimatesOfCoefficients ,
		long double *	pdRSquaredCoefficientOfDetermination ,
		long double *	pdRCorrelationCoefficient ) ;
